# NAS Conference QR Scanner

A web application for scanning QR codes to track attendance at the National Address System Conference.

## Features

- Scan QR codes using device camera
- Record participant attendance in Supabase database
- View real-time attendance statistics
- Track first-time vs. repeat check-ins
- Responsive design for mobile and desktop

## Setup Instructions

### 1. Database Setup

First, add the required columns to your Supabase `rsvp_submissions` table:

```sql
ALTER TABLE rsvp_submissions 
ADD COLUMN attended BOOLEAN DEFAULT FALSE,
ADD COLUMN attendance_time TIMESTAMPTZ;
```

### 2. Install Dependencies

```bash
pip install -r requirements.txt
```

### 3. Environment Variables

Create a `.env` file with your Supabase credentials:

```
SUPABASE_URL=https://your-supabase-project.supabase.co
SUPABASE_KEY=your-supabase-service-role-key
SUPABASE_BUCKET_NAME=qr-codes
```

### 4. Folder Structure

Create the necessary directories:

```
/templates
/static
/temp
```

### 5. Running the Application

```bash
python app.py
```

The application will run on http://127.0.0.1:5001

## Usage

1. Use the QR scanner page to scan participant QR codes
2. View attendance statistics on the stats page
3. QR codes are validated against the Supabase database
4. Attendance is recorded in real-time

## Technical Details

- **Frontend**: HTML, CSS, JavaScript
- **Backend**: Flask (Python)
- **Database**: Supabase
- **QR Scanning**: HTML5-QRCode library
- **Camera Access**: Web API (getUserMedia)

## Integration with RSVP System

This scanner application connects to the same Supabase database as your RSVP system. It reads the participant data from the `rsvp_submissions` table and updates the `attended` and `attendance_time` columns when a QR code is scanned.

## Security Considerations

- The application uses Supabase service role key for database access
- QR codes contain a unique UUID that can't be guessed
- Timestamps are recorded to track when participants checked in

## Notes

- For production deployment, ensure you're using HTTPS
- Consider adding authentication for the statistics page
- Test across different devices and browsers before the event